/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import filenet.sim.appserver.IVWSIMSOAPSessionManager;
import filenet.sim.appserver.IVWSIMSimServerUrlManager;
import filenet.sim.appserver.VWSIMDocHelper;
import filenet.sim.appserver.VWSIMSOAPService;
import filenet.sim.appserver.VWSIMSOAPSessionInfo;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.utils.WSListenerProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.apache.soap.util.xml.XMLParserUtils;

public class VWSIMServlet
extends HttpServlet {
    private static final String PARAMNAME_SOAPCONFIGFILE = "SOAPConfigFile";
    private static final String PARAMVALUE_SOAPCONFIGFILE_DEFAULT = null;
    private static final String PARAMNAME_PROVIDERNAME = "VWSIMServiceProvider";
    private static final String PARAMVALUE_PROVIDER_DEFAULT = "filenet.sim.appserver.VWSIMSOAPServiceProvider";
    private static final String PARAMNAME_CLASS_NAME = "VWSIMServiceClass";
    private static final String PARAMVALUE_CLASS_DEFAULT = "filenet.sim.appserver.VWSIMSOAPService";
    private static final String PARAMNAME_SCOPE = "VWSIMServiceScope";
    private static final String PARAMVALUE_SCOPE_APPLICATION = "Application";
    private static final String PARAMVALUE_SCOPE_SESSION = "Session";
    private static final String PARAMNAME_METHODS = "VWSIMServiceMethods";
    private static final String PARAMNAME_SIM_ENGINE_URL = "VWSIMEngUrl";
    private static final String PARAMVALUE_SIM_ENGINE_URL = "rmi://localhost:32771/WorkflowSimulator";
    private EnvelopeEditor editor = null;
    private static Class VWSIMServiceClass = null;
    private static String simEngineUrl;
    private static Logger logger;
    private static String m_className;
    private static final String CONTENT_TYPE = "text/xml";
    private static final String SYSTEM = "SYSTEM";
    private static final String REGION = "REGION";
    private static final String SIMNAME = "SIMNAME";
    private static final String SIMGUID = "SIMGUID";
    private String m_XMLin;
    private String m_MethodName = "";
    private String m_Params = "";
    private String m_Line = "";
    private String m_soapConfigFileName = null;
    private WSListenerProperties m_wsListenerProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        String m_method = "init";
        try {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            ServletContext servletContext = context = config.getServletContext();
            synchronized (servletContext) {
                this.m_soapConfigFileName = config.getInitParameter(PARAMNAME_SOAPCONFIGFILE);
                if (this.m_soapConfigFileName == null) {
                    this.m_soapConfigFileName = PARAMVALUE_SOAPCONFIGFILE_DEFAULT;
                }
                if (this.m_soapConfigFileName != null) {
                    File f = ServerHTTPUtils.getFileFromNameAndContext((String)this.m_soapConfigFileName, (ServletContext)context);
                    this.m_soapConfigFileName = f.getAbsolutePath();
                    if (!f.exists()) {
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "Ignore non-existent file:" + this.m_soapConfigFileName);
                        }
                        this.m_soapConfigFileName = null;
                    } else if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Using file:" + this.m_soapConfigFileName);
                    }
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "SOAPConfigFile is null.");
                }
                ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)context, (String)this.m_soapConfigFileName);
                serviceManager.deploy(this.getVWSIMSOAPServiceDD());
                logger.info(m_className, m_method, "deployment is successful");
            }
            InputStream inStream = null;
            try {
                inStream = context.getResourceAsStream("/WEB-INF/P8BPMWSBroker.properties");
                String P8BPMWSBROKER_PROPERTIES_FILENAME = WSListenerProperties.getRealPath(inStream, true);
                if (logger.isFinest()) {
                    logger.info(m_className, m_method, P8BPMWSBROKER_PROPERTIES_FILENAME);
                }
                this.m_wsListenerProperties = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, null);
            }
            catch (Throwable t) {
                logger.throwing(m_className, m_method, t);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.throwing(m_className, m_method, e);
            logger.severe(m_className, m_method, "May have not been deployed, better restart the web service.");
        }
    }

    public void setSOAPContext(VWSIMSOAPService obj, VWSIMSOAPSessionInfo ses) {
        obj.setContext("WcmSession", ses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String m_method = "doGet";
        try {
            if (logger.isFinest()) {
                logger.entering(m_className, "doGet");
            }
            VWSIMDocHelper helper = new VWSIMDocHelper(request, response);
            helper.process();
        }
        catch (Throwable e) {
            response.sendError(500, VWException.DescribeThrowableAndItsCause(e));
        }
        finally {
            if (logger.isFinest()) {
                logger.exiting(m_className, "doGet");
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String m_method = "doPost";
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        HttpSession session = request.getSession();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)context, (String)this.m_soapConfigFileName);
        Call call = null;
        Response resp = null;
        String targetID = null;
        String fullTargetID = null;
        int status = 200;
        DeploymentDescriptor dd = null;
        SOAPContext reqCtx = new SOAPContext();
        SOAPContext resCtx = new SOAPContext();
        Envelope callEnv = null;
        reqCtx.setClassLoader(ServerHTTPUtils.getServletClassLoaderFromContext((ServletContext)context));
        VWSIMSOAPSessionInfo ses = new VWSIMSOAPSessionInfo();
        try {
            try {
                ses.verifyCredentials(context, request, this.m_wsListenerProperties);
                try {
                    try {
                        DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
                        callEnv = ServerUtils.readEnvelopeFromInputStream((DocumentBuilder)xdb, (InputStream)request.getInputStream(), (int)request.getContentLength(), (String)request.getContentType(), (EnvelopeEditor)this.editor, (SOAPContext)reqCtx);
                    }
                    catch (IllegalArgumentException e) {
                        response.sendError(400, "Error unmarshalling envelope: " + e.getMessage());
                        callEnv = null;
                    }
                    catch (MessagingException me) {
                        response.sendError(400, "Error unmarshalling envelope: " + (Object)((Object)me));
                        callEnv = null;
                    }
                    if (callEnv == null) {
                        return;
                    }
                    call = RPCRouter.extractCallFromEnvelope((ServiceManager)serviceManager, (Envelope)callEnv, (SOAPContext)reqCtx);
                    targetID = call.getTargetObjectURI();
                    fullTargetID = call.getFullTargetObjectURI();
                }
                catch (IllegalArgumentException e) {
                    String msg = e.getMessage();
                    String faultCode = msg != null && msg.equals(Constants.ERR_MSG_VERSION_MISMATCH) ? Constants.FAULT_CODE_VERSION_MISMATCH : Constants.FAULT_CODE_CLIENT;
                    throw new SOAPException(faultCode, msg, (Throwable)e);
                }
                dd = serviceManager.query(targetID);
                RPCJavaProvider provider = null;
                if (dd.getProviderType() == 0) {
                    provider = new RPCJavaProvider();
                } else if (dd.getProviderType() == 3) {
                    Class<?> c = Class.forName(dd.getProviderClass());
                    provider = (Provider)c.newInstance();
                } else {
                    provider = new RPCJavaProvider();
                }
                reqCtx.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                reqCtx.setProperty(Constants.BAG_HTTPSESSION, (Object)session);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETREQUEST, (Object)request);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, (Object)response);
                ((IVWSIMSOAPSessionManager)provider).setSession(ses);
                ((IVWSIMSimServerUrlManager)provider).setUrl(simEngineUrl);
                provider.locate(dd, callEnv, call, call.getMethodName(), fullTargetID, reqCtx);
                provider.invoke(reqCtx, resCtx);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "provider.invoke finished");
                }
            }
            catch (Throwable t) {
                SOAPException e = null;
                e = t instanceof SOAPException ? (SOAPException)t : new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception:", "", t);
                Fault fault = new Fault(e);
                fault.setFaultActorURI(request.getRequestURI());
                if (dd != null) {
                    dd.buildFaultRouter(reqCtx).notifyListeners(fault, e);
                }
                status = 500;
                String respEncStyle = null;
                if (call != null) {
                    respEncStyle = call.getEncodingStyleURI();
                }
                if (respEncStyle == null) {
                    respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                }
                resCtx = new SOAPContext();
                resp = new Response(null, null, fault, null, null, respEncStyle, resCtx);
                SOAPMappingRegistry smr = call != null ? call.getSOAPMappingRegistry() : new SOAPMappingRegistry();
                Envelope env = resp.buildEnvelope();
                StringWriter sw = new StringWriter();
                env.marshall((Writer)sw, (XMLJavaMappingRegistry)smr, resp.getSOAPContext());
                resp.getSOAPContext().setRootPart(sw.toString(), "text/xml;charset=utf-8");
            }
            TransportMessage sres = new TransportMessage(null, resCtx, null);
            sres.editOutgoing(this.editor);
            sres.save();
            response.setStatus(status);
            response.setContentType(sres.getContentType());
            Enumeration headers = sres.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                response.setHeader(name, sres.getHeader(name));
            }
            response.setContentLength(sres.getContentLength());
            ServletOutputStream outStream = response.getOutputStream();
            sres.writeTo((OutputStream)outStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Error building response envelope: " + e);
        }
    }

    String getValue(String strIn, String strSub) throws Exception {
        String sBegin = "<" + strSub + ">";
        String sEnd = "</" + strSub + ">";
        int iStart = strIn.indexOf(sBegin);
        int iEnd = strIn.indexOf(sEnd);
        if (iEnd == -1 || iStart == -1) {
            sBegin = "<" + strSub + "/>";
            iStart = strIn.indexOf(sBegin);
            if (iStart != -1) {
                return "";
            }
            if (strSub.compareTo(strSub.toLowerCase(Locale.ENGLISH)) != 0) {
                return this.getValue(strIn, strSub.toLowerCase(Locale.ENGLISH));
            }
        }
        return strIn.substring(iStart += sBegin.length(), iEnd);
    }

    private DeploymentDescriptor getVWSIMSOAPServiceDD() throws Exception {
        String serviceClassName;
        ServletConfig config = this.getServletConfig();
        String providerName = config.getInitParameter(PARAMNAME_PROVIDERNAME);
        if (providerName == null) {
            providerName = PARAMVALUE_PROVIDER_DEFAULT;
        }
        if ((serviceClassName = config.getInitParameter(PARAMNAME_CLASS_NAME)) == null) {
            serviceClassName = PARAMVALUE_CLASS_DEFAULT;
        }
        int serviceScope = 0;
        String serviceScopeStr = config.getInitParameter(PARAMNAME_SCOPE);
        if (serviceScopeStr != null) {
            if (serviceScopeStr.equalsIgnoreCase(PARAMVALUE_SCOPE_APPLICATION)) {
                serviceScope = 2;
            } else if (serviceScopeStr.equalsIgnoreCase(PARAMVALUE_SCOPE_SESSION)) {
                serviceScope = 1;
            }
        }
        VWSIMServiceClass = Class.forName(serviceClassName);
        String serviceMethods = config.getInitParameter(PARAMNAME_METHODS);
        String[] svcs = null;
        if (serviceMethods != null) {
            svcs = this.parseStringList(serviceMethods);
        } else {
            Method[] methods = VWSIMServiceClass.getMethods();
            if (methods != null) {
                int nMethods = methods.length;
                Vector<String> v = new Vector<String>(nMethods);
                while (nMethods-- > 0) {
                    Method m = methods[nMethods];
                    if (!m.getDeclaringClass().equals(VWSIMServiceClass)) continue;
                    v.add(m.getName());
                }
                if (v.isEmpty()) {
                    throw new Exception("No public methods can be found in " + serviceClassName);
                }
                svcs = v.toArray(new String[0]);
            }
        }
        if (svcs == null) {
            throw new Exception("No methods are declared for the " + serviceClassName);
        }
        simEngineUrl = config.getInitParameter(PARAMNAME_SIM_ENGINE_URL);
        if (simEngineUrl == null) {
            simEngineUrl = PARAMVALUE_SIM_ENGINE_URL;
        }
        DeploymentDescriptor dd = new DeploymentDescriptor();
        dd.setID("urn:filenet-sim-appserver");
        dd.setMethods(svcs);
        dd.setScope(serviceScope);
        dd.setProviderType((byte)3);
        dd.setProviderClass(providerName);
        dd.setServiceClass(providerName);
        dd.setIsStatic(false);
        logger.exiting(m_className, "getVWSIMSOAPServiceDD", dd);
        return dd;
    }

    private String[] parseStringList(String source) {
        if (source == null) {
            return null;
        }
        String m_method = "parseStringList:" + source;
        StringTokenizer st = new StringTokenizer(source, ", ");
        int nTokens = st.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    private int[] parseIntList(String source) {
        if (source == null) {
            return null;
        }
        String m_method = "parseIntList:" + source;
        StringTokenizer st = new StringTokenizer(source, ", ");
        int nTokens = st.countTokens();
        int[] res = new int[nTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                res[i++] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                res = null;
                return null;
            }
        }
        return res;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:47:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    static {
        logger = Logger.getLogger("filenet.sim.appserver");
        m_className = "VWSIMServlet";
    }
}

